
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1242.C - Message 1242 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1242 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1242 message from the ZMsgBuf.
//
void Dec1242(tMSGBUF *ZMsgBuf, tMSG1242 *Msg)
{
; // whatever
}                                      

end not needed yet */
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1242 message in the ZMsgBuf.
//
void Bld1242(tMSGBUF *ZMsgBuf, tMSG1242 *Msg)
{
 
  tSHORT index=0;
  
  for(index=5; index<19; index++) ZMsgBuf->word[index] = ZMsgBuf->word[index+2];

   // build the header in the buffer
   PutShort  (0x81FF                         , ZMsgBuf, 1);     // message preamble
   PutShort  (1242                           , ZMsgBuf, 2);     // message number
   PutShort  (14                             , ZMsgBuf, 3);     // message length
   PutShort  (ANREQ                          , ZMsgBuf, 4);     // message ack/nack request
                                                   
}                                            


/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1242 message from the ZMsgBuf.
//
void Show1242(tMSG1242 *Msg)
{
; // whatever
}                                                 

end not needed yet */
                                      
                                           
